/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.block;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.block.Floatable;
import com.aetherteam.aether.block.miscellaneous.FloatingBlock;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.mixin.mixins.common.accessor.ConcretePowderBlockAccessor;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1313;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2292;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class FloatingBlockEntity
extends class_1297 {
    private static final class_2940<class_2338> DATA_START_POS = class_2945.method_12791(FloatingBlockEntity.class, (class_2941)class_2943.field_13324);
    private class_2680 blockState = class_2246.field_10102.method_9564();
    private int time;
    private boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    private int floatDistance;
    @Nullable
    private class_2487 blockData;
    public boolean forceTickAfterTeleportToDuplicate;
    private boolean natural = true;

    public FloatingBlockEntity(class_1299<? extends FloatingBlockEntity> type, class_1937 level) {
        super(type, level);
    }

    public FloatingBlockEntity(class_1937 level, double x, double y, double z, class_2680 state) {
        this(AetherEntityTypes.FLOATING_BLOCK.get(), level);
        this.blockState = state;
        this.field_23807 = true;
        this.method_5814(x, y + (double)((1.0f - this.method_17682()) / 2.0f), z);
        this.method_18799(class_243.field_1353);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.setStartPos(this.method_24515());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_START_POS, (Object)class_2338.field_10980);
    }

    public void method_5773() {
        if (this.getBlockState().method_26215()) {
            this.method_31472();
        } else {
            class_1937 class_19372;
            class_2248 block = this.getBlockState().method_26204();
            if (this.time++ == 0) {
                class_2338 blockPos = this.method_24515();
                if (this.method_37908().method_8320(blockPos).method_27852(block)) {
                    this.method_37908().method_8650(blockPos, false);
                }
            }
            this.method_56990();
            this.floatDistance = this.method_24515().method_10264() - this.getStartPos().method_10264();
            if (this.method_37908().method_8608()) {
                this.spawnFloatingBlockParticles();
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_60698();
            if (!this.method_37908().method_8608() && (class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                if (this.method_5805() || this.forceTickAfterTeleportToDuplicate) {
                    class_3965 blockHitResult;
                    class_2338 blockPos1 = this.method_24515();
                    boolean isConcrete = this.getBlockState().method_26204() instanceof class_2292;
                    boolean canConvert = isConcrete && this.method_37908().method_8316(blockPos1).method_15767(class_3486.field_15517);
                    double d0 = this.method_18798().method_1027();
                    if (isConcrete && d0 > 1.0 && (blockHitResult = this.method_37908().method_17742(new class_3959(new class_243(this.field_6014, this.field_6036, this.field_5969), this.method_19538(), class_3959.class_3960.field_17558, class_3959.class_242.field_1345, (class_1297)this))).method_17783() != class_239.class_240.field_1333 && this.method_37908().method_8316(blockHitResult.method_17777()).method_15767(class_3486.field_15517)) {
                        blockPos1 = blockHitResult.method_17777();
                        canConvert = true;
                    }
                    if (!(this.field_5992 && !this.method_24828() || canConvert)) {
                        if (!(this.method_37908().method_8608() || (this.time <= 100 || blockPos1.method_10264() > this.method_37908().method_31607() && blockPos1.method_10264() <= this.method_37908().method_31600()) && this.time <= 600)) {
                            if ((!this.natural || !this.getBlockState().method_29291()) && this.dropItem && this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                                this.dropBlock(this.getBlockState());
                            }
                            this.method_31472();
                        }
                    } else {
                        class_2680 blockState = this.method_37908().method_8320(blockPos1);
                        this.method_18799(this.method_18798().method_18805(0.7, -0.5, 0.7));
                        if (!blockState.method_27852(class_2246.field_10008)) {
                            if (!this.cancelDrop) {
                                boolean canBlockSurvive;
                                boolean canBeReplaced = blockState.method_26166((class_1750)new class_2968(this.method_37908(), blockPos1, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033));
                                boolean isAboveFree = FloatingBlock.isFree(this.method_37908().method_8320(blockPos1.method_10084())) && (!isConcrete || !canConvert);
                                boolean bl = canBlockSurvive = this.getBlockState().method_26184((class_4538)this.method_37908(), blockPos1) && !isAboveFree;
                                if (canBeReplaced && canBlockSurvive || this.natural && blockState.method_26204().method_36555() >= 0.0f) {
                                    if (this.getBlockState().method_28498((class_2769)class_2741.field_12508) && this.method_37908().method_8316(blockPos1).method_39360((class_3611)class_3612.field_15910)) {
                                        this.blockState = (class_2680)this.getBlockState().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
                                    }
                                    class_2680 previousBlockState = this.method_37908().method_8320(blockPos1);
                                    if (this.method_37908().method_8652(blockPos1, this.getBlockState(), 3)) {
                                        class_2586 blockEntity;
                                        if (this.natural && !previousBlockState.method_26215()) {
                                            this.dropBlock(previousBlockState);
                                        }
                                        serverLevel.method_14178().field_17254.method_18702((class_1297)this, (class_2596)new class_2626(blockPos1, this.method_37908().method_8320(blockPos1)));
                                        this.method_31472();
                                        class_2248 class_22482 = block;
                                        Objects.requireNonNull(class_22482);
                                        class_2248 class_22483 = class_22482;
                                        int n = 0;
                                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Floatable.class, class_2292.class, class_2199.class}, (Object)class_22483, n)) {
                                            case 0: {
                                                Floatable floatable = (Floatable)class_22483;
                                                floatable.onCollide(this.method_37908(), blockPos1, this.getBlockState(), blockState, this);
                                                break;
                                            }
                                            case 1: {
                                                class_2292 concretePowderBlock = (class_2292)class_22483;
                                                if (!ConcretePowderBlockAccessor.callShouldSolidify((class_1922)this.method_37908(), blockPos1, blockState)) break;
                                                ConcretePowderBlockAccessor concretePowderBlockAccessor = (ConcretePowderBlockAccessor)concretePowderBlock;
                                                this.method_37908().method_8652(blockPos1, concretePowderBlockAccessor.aether$getConcrete().method_9564(), 3);
                                                break;
                                            }
                                            case 2: {
                                                class_2199 anvilBlock = (class_2199)class_22483;
                                                if (this.method_5701()) break;
                                                this.method_37908().method_20290(1029, blockPos1, 0);
                                                break;
                                            }
                                        }
                                        if (this.blockData != null && this.getBlockState().method_31709() && (blockEntity = this.method_37908().method_8321(blockPos1)) != null) {
                                            class_2487 tag = blockEntity.method_38244((class_7225.class_7874)this.method_37908().method_30349());
                                            for (String s : this.blockData.method_10541()) {
                                                tag.method_10566(s, this.blockData.method_10580(s).method_10707());
                                            }
                                            try {
                                                blockEntity.method_58690(tag, (class_7225.class_7874)this.method_37908().method_30349());
                                            }
                                            catch (Exception exception) {
                                                Aether.LOGGER.error("Failed to load block entity from floating block", (Throwable)exception);
                                            }
                                            blockEntity.method_5431();
                                        }
                                    } else if ((!this.natural || !this.getBlockState().method_29291()) && this.dropItem && this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                                        this.method_31472();
                                        this.callOnBrokenAfterFall(block, blockPos1);
                                        this.dropBlock(this.getBlockState());
                                    }
                                } else {
                                    this.method_31472();
                                    if ((!this.natural || !this.getBlockState().method_29291() || blockState.method_26204().method_36555() < 0.0f) && this.dropItem && this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                                        this.callOnBrokenAfterFall(block, blockPos1);
                                        this.dropBlock(this.getBlockState());
                                    }
                                }
                            } else {
                                this.method_31472();
                                this.callOnBrokenAfterFall(block, blockPos1);
                            }
                        }
                    }
                }
            }
            this.method_18799(this.method_18798().method_1021(0.98));
        }
    }

    public void setHurtsEntities(float fallDamagePerDistance, int fallDamageMax) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = fallDamagePerDistance;
        this.fallDamageMax = fallDamageMax;
    }

    private void dropBlock(class_2680 state) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (class_1799 stack : class_2248.method_9562((class_2680)state, (class_3218)serverLevel, (class_2338)this.method_24515(), null)) {
                this.method_5775(stack);
            }
        }
    }

    public void callOnBrokenAfterFall(class_2248 block, class_2338 pos) {
        if (block instanceof Floatable) {
            Floatable floatable = (Floatable)block;
            floatable.onBrokenAfterCollide(this.method_37908(), pos, this);
        }
    }

    protected void method_56990() {
        double d0 = this.method_56989();
        if (d0 != 0.0) {
            this.method_18799(this.method_18798().method_1031(0.0, d0, 0.0));
        }
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        int i;
        if (this.hurtEntities && (i = this.floatDistance) >= 0) {
            class_1282 class_12822;
            Predicate predicate = class_1301.field_6156.and(class_1301.field_6157);
            class_2248 class_22482 = this.blockState.method_26204();
            if (class_22482 instanceof Floatable) {
                Floatable floatable = (Floatable)class_22482;
                class_12822 = floatable.getFallDamageSource(this);
            } else {
                class_12822 = AetherDamageTypes.entityDamageSource(this.method_37908(), AetherDamageTypes.FLOATING_BLOCK, this);
            }
            class_1282 damageSource = class_12822;
            float f = Math.min(class_3532.method_15375((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
            this.method_37908().method_8333((class_1297)this, this.method_5829(), predicate).forEach(entity -> entity.method_5643(damageSource, f));
            boolean flag = this.getBlockState().method_26164(class_3481.field_15486);
            if (flag && f > 0.0f && this.field_5974.method_43057() < 0.05f + (float)i * 0.05f) {
                class_2680 blockstate = class_2199.method_9346((class_2680)this.getBlockState());
                if (blockstate == null) {
                    this.disableDrop();
                } else {
                    this.blockState = blockstate;
                }
            }
        }
        return false;
    }

    private void spawnFloatingBlockParticles() {
        if (this.field_5974.method_43048(8) == 0) {
            double d0 = this.method_23317() - 0.5 + this.field_5974.method_43058();
            double d1 = this.method_23318() - 0.05;
            double d2 = this.method_23321() - 0.5 + this.field_5974.method_43058();
            this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11206, this.getBlockState()), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void setStartPos(class_2338 pOrigin) {
        this.method_5841().method_12778(DATA_START_POS, (Object)pOrigin);
    }

    public class_2338 getStartPos() {
        return (class_2338)this.method_5841().method_12789(DATA_START_POS);
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    public boolean method_5732() {
        return false;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    protected double method_7490() {
        return 0.04;
    }

    public boolean method_5862() {
        return false;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5833() {
        return true;
    }

    protected class_2561 method_23315() {
        return class_2561.method_43469((String)"entity.aether.floating_block_type", (Object[])new Object[]{this.blockState.method_26204().method_9518()});
    }

    @Nullable
    public class_1297 method_5731(class_5454 transition) {
        class_5321 newDimension = transition.comp_2820().method_27983();
        class_5321 currentDimension = this.method_37908().method_27983();
        boolean flag = (currentDimension == class_1937.field_25181 || newDimension == class_1937.field_25181) && currentDimension != newDimension;
        class_1297 entity = super.method_5731(transition);
        this.forceTickAfterTeleportToDuplicate = entity != null && flag;
        return entity;
    }

    protected void method_5652(class_2487 tag) {
        tag.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.blockState));
        tag.method_10569("Time", this.time);
        tag.method_10556("DropItem", this.dropItem);
        tag.method_10556("HurtEntities", this.hurtEntities);
        tag.method_10548("FallHurtAmount", this.fallDamagePerDistance);
        tag.method_10569("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            tag.method_10566("TileEntityData", (class_2520)this.blockData);
        }
        tag.method_10556("Natural", this.natural);
        tag.method_10556("CancelDrop", this.cancelDrop);
    }

    protected void method_5749(class_2487 tag) {
        if (tag.method_10545("BlockState")) {
            this.blockState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)tag.method_10562("BlockState"));
        }
        if (tag.method_10545("Time")) {
            this.time = tag.method_10550("Time");
        }
        if (tag.method_10573("HurtEntities", 99)) {
            this.hurtEntities = tag.method_10577("HurtEntities");
            this.fallDamagePerDistance = tag.method_10583("FallHurtAmount");
            this.fallDamageMax = tag.method_10550("FallHurtMax");
        } else if (this.blockState.method_26164(class_3481.field_15486)) {
            this.hurtEntities = true;
        }
        if (tag.method_10573("DropItem", 99)) {
            this.dropItem = tag.method_10577("DropItem");
        }
        if (tag.method_10573("TileEntityData", 10)) {
            this.blockData = tag.method_10562("TileEntityData");
        }
        if (this.blockState.method_26215()) {
            this.blockState = class_2246.field_10102.method_9564();
        }
        if (tag.method_10545("CancelDrop")) {
            this.cancelDrop = tag.method_10577("CancelDrop");
        }
        if (tag.method_10573("Natural", 99)) {
            this.natural = tag.method_10577("Natural");
        }
    }

    public class_2596<class_2602> method_18002(class_3231 entity) {
        return new class_2604((class_1297)this, entity, class_2248.method_9507((class_2680)this.getBlockState()));
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.blockState = class_2248.method_9531((int)packet.method_11166());
        this.field_23807 = true;
        double d0 = packet.method_11175();
        double d1 = packet.method_11174();
        double d2 = packet.method_11176();
        this.method_5814(d0, d1, d2);
        this.setStartPos(this.method_24515());
    }

    public void method_5819(class_129 category) {
        super.method_5819(category);
        category.method_578("Imitating BlockState", (Object)this.getBlockState().toString());
    }
}

